# The PEP 484 type hints stub file for the Enginio module.
#
# Generated by SIP 4.18.1
#
# Copyright (c) 2016 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt5.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import typing
import sip

from PyQt5 import QtNetwork
from PyQt5 import QtCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]


class Enginio(sip.simplewrapper):

    class ErrorType(int): ...
    NoError = ... # type: 'Enginio.ErrorType'
    NetworkError = ... # type: 'Enginio.ErrorType'
    BackendError = ... # type: 'Enginio.ErrorType'

    class Role(int): ...
    SyncedRole = ... # type: 'Enginio.Role'
    CreatedAtRole = ... # type: 'Enginio.Role'
    UpdatedAtRole = ... # type: 'Enginio.Role'
    IdRole = ... # type: 'Enginio.Role'
    ObjectTypeRole = ... # type: 'Enginio.Role'
    CustomPropertyRole = ... # type: 'Enginio.Role'
    JsonObjectRole = ... # type: 'Enginio.Role'

    class Operation(int): ...
    ObjectOperation = ... # type: 'Enginio.Operation'
    AccessControlOperation = ... # type: 'Enginio.Operation'
    UserOperation = ... # type: 'Enginio.Operation'
    UsergroupOperation = ... # type: 'Enginio.Operation'
    UsergroupMembersOperation = ... # type: 'Enginio.Operation'
    FileOperation = ... # type: 'Enginio.Operation'

    class AuthenticationState(int): ...
    NotAuthenticated = ... # type: 'Enginio.AuthenticationState'
    Authenticating = ... # type: 'Enginio.AuthenticationState'
    Authenticated = ... # type: 'Enginio.AuthenticationState'
    AuthenticationFailure = ... # type: 'Enginio.AuthenticationState'


class EnginioClientConnection(QtCore.QObject):

    def identityChanged(self, identity: 'EnginioIdentity') -> None: ...
    def authenticationStateChanged(self, state: Enginio.AuthenticationState) -> None: ...
    def serviceUrlChanged(self, url: QtCore.QUrl) -> None: ...
    def backendIdChanged(self, backendId: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def networkManager(self) -> QtNetwork.QNetworkAccessManager: ...
    def setServiceUrl(self, serviceUrl: QtCore.QUrl) -> None: ...
    def serviceUrl(self) -> QtCore.QUrl: ...
    def authenticationState(self) -> Enginio.AuthenticationState: ...
    def setIdentity(self, identity: 'EnginioIdentity') -> None: ...
    def identity(self) -> 'EnginioIdentity': ...
    def setBackendId(self, backendId: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def backendId(self) -> QtCore.QByteArray: ...


class EnginioClient(EnginioClientConnection):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def error(self, reply: 'EnginioReply') -> None: ...
    def finished(self, reply: 'EnginioReply') -> None: ...
    def sessionTerminated(self) -> None: ...
    def sessionAuthenticationError(self, reply: 'EnginioReply') -> None: ...
    def sessionAuthenticated(self, reply: 'EnginioReply') -> None: ...
    def downloadUrl(self, object: typing.Dict[str, QtCore.QJsonValue]) -> 'EnginioReply': ...
    def uploadFile(self, associatedObject: typing.Dict[str, QtCore.QJsonValue], file: QtCore.QUrl) -> 'EnginioReply': ...
    def remove(self, object: typing.Dict[str, QtCore.QJsonValue], operation: Enginio.Operation = ...) -> 'EnginioReply': ...
    def update(self, object: typing.Dict[str, QtCore.QJsonValue], operation: Enginio.Operation = ...) -> 'EnginioReply': ...
    def create(self, object: typing.Dict[str, QtCore.QJsonValue], operation: Enginio.Operation = ...) -> 'EnginioReply': ...
    def query(self, query: typing.Dict[str, QtCore.QJsonValue], operation: Enginio.Operation = ...) -> 'EnginioReply': ...
    def fullTextSearch(self, query: typing.Dict[str, QtCore.QJsonValue]) -> 'EnginioReply': ...


class EnginioIdentity(QtCore.QObject): ...


class EnginioModel(QtCore.QAbstractListModel):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def operationChanged(self, operation: Enginio.Operation) -> None: ...
    def clientChanged(self, client: EnginioClient) -> None: ...
    def queryChanged(self, query: typing.Dict[str, QtCore.QJsonValue]) -> None: ...
    def reload(self) -> 'EnginioReply': ...
    @typing.overload
    def setData(self, row: int, value: typing.Any, role: str) -> 'EnginioReply': ...
    @typing.overload
    def setData(self, row: int, value: typing.Dict[str, QtCore.QJsonValue]) -> 'EnginioReply': ...
    def remove(self, row: int) -> 'EnginioReply': ...
    def append(self, value: typing.Dict[str, QtCore.QJsonValue]) -> 'EnginioReply': ...
    def setOperation(self, operation: Enginio.Operation) -> None: ...
    def operation(self) -> Enginio.Operation: ...
    def setQuery(self, query: typing.Dict[str, QtCore.QJsonValue]) -> None: ...
    def query(self) -> typing.Dict[str, QtCore.QJsonValue]: ...
    def setClient(self, client: EnginioClient) -> None: ...
    def client(self) -> EnginioClient: ...


class EnginioOAuth2Authentication(EnginioIdentity):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def passwordChanged(self, password: str) -> None: ...
    def userChanged(self, user: str) -> None: ...
    def setPassword(self, password: str) -> None: ...
    def setUser(self, user: str) -> None: ...
    def password(self) -> str: ...
    def user(self) -> str: ...


class EnginioReply(QtCore.QObject):

    def dataChanged(self) -> None: ...
    def finished(self, reply: 'EnginioReply') -> None: ...
    def isFinished(self) -> bool: ...
    def isError(self) -> bool: ...
    def backendStatus(self) -> int: ...
    def errorString(self) -> str: ...
    def networkError(self) -> QtNetwork.QNetworkReply.NetworkError: ...
    def errorType(self) -> Enginio.ErrorType: ...
    def progress(self, bytesSent: int, bytesTotal: int) -> None: ...
    def data(self) -> typing.Dict[str, QtCore.QJsonValue]: ...
